/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'jquerymobile', 'core/utilities/authentication', 'hbs!modules/app-about/aboutPopup' ],
    function (Portal, Backbone, Marionette, $, jqm, authentication, template) {
        return Backbone.Marionette.ItemView.extend({
            model: Portal.packageData(),
            tagName: 'div',
            id: "portal-about-popup",
            attributes: {
                'data-role': 'popup'
            },
            template: template,
            modelEvents: {
                'change': 'render'
            },
            initialize : function () {
                Portal.commands.setHandler("open-portal-about", this.openAbout, this);
                Portal.vent.on('close:popups', this.closeAbout, this);
            },
            onRender: function () {
                this.$el.popup({
                    shadow: true,                  // Shadow around popup
                    transition: "fade",            // How to animate in.
                    corners: false,                // No rounded Edges
                    tolerance: "41,0",             // Edges from window
                    dismissible: true,             // Click anywhere to close.
                    overlayTheme: 'a'
                });
            },
            onClose: function() {
                Portal.vent.off('close:popups');
                this.stopListening();
                this.off();
            },
            openAbout: function () {
                this.render();
                this.$el.popup('open');
            },
            closeAbout: function() {
               $('#' + this.id).popup('close');
            }
        });
    });